#include "stablo.h"
#include <stdlib.h>

/* ---------- pomoćne ---------- */

static Cvor* cvor_novi(int x) {
    Cvor* n = (Cvor*)malloc(sizeof(Cvor));
    if (!n) return NULL;
    n->vrednost = x;
    n->levo = NULL;
    n->desno = NULL;
    return n;
}

/* ---------- uništavanje ---------- */

void stablo_unisti(Cvor* koren) {
    if (!koren) return;
    stablo_unisti(koren->levo);
    stablo_unisti(koren->desno);
    free(koren);
}

/* ---------- ubacivanje: BST ---------- */
/* Dogovor: x < vrednost ide levo, inače desno */

int stablo_ubaci(Cvor** koren, int x) {
    if (!koren) return 0;

    while (*koren) {
        if (x < (*koren)->vrednost)
            koren = &(*koren)->levo;
        else
            koren = &(*koren)->desno;
    }

    *koren = cvor_novi(x);
    return (*koren != NULL);
}

/* ---------- obilasci ---------- */

void stablo_infiksno(Cvor* koren, void (*visit)(int)) {
    if (!koren) return;
    stablo_infiksno(koren->levo, visit);
    visit(koren->vrednost);
    stablo_infiksno(koren->desno, visit);
}

void stablo_prefiksno(Cvor* koren, void (*visit)(int)) {
    if (!koren) return;
    visit(koren->vrednost);
    stablo_prefiksno(koren->levo, visit);
    stablo_prefiksno(koren->desno, visit);
}

void stablo_postfiksno(Cvor* koren, void (*visit)(int)) {
    if (!koren) return;
    stablo_postfiksno(koren->levo, visit);
    stablo_postfiksno(koren->desno, visit);
    visit(koren->vrednost);
}

Cvor *stablo_pretrazi(Cvor *koren, int x)
{
    if (!koren) return NULL;

    if (koren->vrednost == x)
        return koren;
    else if (x < koren->vrednost)
        return stablo_pretrazi(koren->levo, x);
    else
        return stablo_pretrazi(koren->desno, x);
}

void stablo_obrisi(Cvor **koren, int x)
{
    if (!koren || !*koren) return;

    if (x < (*koren)->vrednost) {
        stablo_obrisi(&(*koren)->levo, x);
        return;
    } 
    
    if (x > (*koren)->vrednost) {
        stablo_obrisi(&(*koren)->desno, x);
        return;
    }

    // Čvor za brisanje pronađen
    if (!(*koren)->levo) {
        Cvor *temp = (*koren)->desno;
        free(*koren);
        *koren = temp;
        return;
    }
    
    if (!(*koren)->desno) {
        Cvor *temp = (*koren)->levo;
        free(*koren);
        *koren = temp;
        return;
    }

    // Čvor sa dva deteta: nađi najmanji u desnom podstablu
    Cvor *parent = *koren;
    Cvor *successor = (*koren)->desno;
    while (successor->levo) {
        parent = successor;
        successor = successor->levo;
    }

    // Kopiraj vrednost naslednika
    (*koren)->vrednost = successor->vrednost;

    // Obriši naslednika
    if (parent->levo == successor)
        parent->levo = successor->desno;
    else
        parent->desno = successor->desno;
    free(successor);
}

/* ---------- size / height ---------- */

size_t stablo_velicina(Cvor* koren) {
    if (!koren) return 0;
    return 1
         + stablo_velicina(koren->levo)
         + stablo_velicina(koren->desno);
}

size_t stablo_visina(Cvor* koren) {
    if (!koren) return 0;
    size_t hl = stablo_visina(koren->levo);
    size_t hr = stablo_visina(koren->desno);
    return 1 + (hl > hr ? hl : hr);
}