#ifndef STABLO_H
#define STABLO_H

#include <stddef.h>

typedef struct Cvor {
    int vrednost;
    struct Cvor* levo;
    struct Cvor* desno;
} Cvor;

/* Ubacivanje */
int stablo_ubaci(Cvor** koren, int x);

/* Uništavanje */
void stablo_unisti(Cvor* koren);

/* Obilasci */
void stablo_infiksno(Cvor* koren, void (*visit)(int));
void stablo_prefiksno(Cvor* koren, void (*visit)(int));
void stablo_postfiksno(Cvor* koren, void (*visit)(int));

/* Pretraga */
Cvor* stablo_pretrazi(Cvor* koren, int x);

/* Brisanje */
void stablo_obrisi(Cvor** koren, int x);

/* Analiza */
size_t stablo_velicina(Cvor* koren);
size_t stablo_visina(Cvor* koren);

#endif