#include "stablo_genericko.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

cvor_stabla* novi_cvor_stabla(const Data* podatak) 
{
  cvor_stabla* novi = malloc(sizeof(cvor_stabla));
  if (novi == NULL)
    return NULL;
  dodeli(&(novi->podatak), podatak);
  novi->levo = NULL;
  novi->desno = NULL;
  return novi;
}

status inicijalizuj_stablo(Stablo* s) 
{
  *s = NULL;
  return OK;
}

status dodaj_u_stablo(Stablo* s, const Data* podatak, 
                      int (*poredi)(const Data*, const Data*))
{
  cvor_stabla* tmp;
  cvor_stabla* novi = novi_cvor_stabla(podatak);
  if (novi == NULL)
    return NEDOVOLJNO_MEMORIJE;
  novi->levo = NULL;
  novi->desno = NULL;

  if (*s == NULL) { 
    *s = novi;
    return OK;
  }
  tmp = *s;
  while (1) {
    if (poredi(podatak, &(tmp->podatak)) <= 0) {
      if (tmp->levo == NULL) {
          tmp->levo = novi;
        return OK;
      }
      else
        tmp = tmp->levo;
    }
    else {
      if (tmp->desno == NULL) {
          tmp->desno = novi;
        return OK;
      }
      else
        tmp = tmp->desno;
    }
  }
  return OK;
}

status pronadji(Stablo s, const Data* trazeno, Data** nadjeno, 
                int (*poredi)(const Data*, const Data*))
{
  if (s == NULL)
    return NEMA_ELEMENATA;
  if (poredi(trazeno, &(s->podatak)) == 0) {
    *nadjeno = &(s->podatak);
    return OK;
  }
  if (poredi(trazeno, &(s->podatak)) < 0) 
    return pronadji(s->levo, trazeno, nadjeno, poredi);
  return pronadji(s->desno, trazeno, nadjeno, poredi);
}

int broj_elemenata(Stablo s)
{
  return s == NULL ? 
           0 : 
           broj_elemenata(s->levo)+1+broj_elemenata(s->desno);
}

void ispisi_stablo(Stablo s) 
{
  if (s != NULL) {
     ispisi_stablo(s->levo);      
     ispisi_podatak(&(s->podatak)); 
     ispisi_stablo(s->desno);    
  }
}

void obrisi_stablo(Stablo* s) 
{
  if (*s != NULL) {
    obrisi_stablo(&((*s)->levo));
    obrisi_stablo(&((*s)->desno));
    free(*s);
    *s = NULL;
  }
}