#ifndef __STABLO_GENERICKO_H__
#define __STABLO_GENERICKO_H__

#include <stdio.h>
#include <stdlib.h>
#include "stablo_podatak.h"

typedef enum {
   OK,
   NEDOVOLJNO_MEMORIJE,
   NEMA_ELEMENATA
} status;

typedef struct cvor_stabla {
  Data podatak;
  struct cvor_stabla* levo;
  struct cvor_stabla* desno;
} cvor_stabla;

typedef cvor_stabla* Stablo;

status inicijalizuj_stablo(Stablo* s); 
status dodaj_u_stablo(Stablo* s, const Data* podatak, 
                      int (*poredi)(const Data*, const Data*));
status pronadji(Stablo s, const Data* trazeno, Data** nadjeno, 
                int (*poredi)(const Data*, const Data*));
int broj_elemenata(Stablo s);
void ispisi_stablo(Stablo s);
void obrisi_stablo(Stablo* s); 

#endif

