#include <stdio.h>
#include <string.h>

int main(void) {
    // Deklaracija niza fiksne veličine
    char a[50] = "Zdravo";  // ima 50 bajtova, "Zdravo" + \0 + još praznog prostora

    // Deklaracija niza kome kompajler sam odredi veličinu
    char b[] = "svete";     // ima tačno 6 bajtova ("svete\0")

    // Pokazivač na literal (read-only deo memorije)
    char* c = "pera";       // ne može se menjati sadržaj, samo pokazivač

    printf("a = %s\n", a);
    printf("b = %s\n", b);
    printf("c = %s\n", c);

    printf("\n--- sizeof ---\n");
    printf("sizeof(a) = %zu\n", sizeof(a));  // 50
    printf("sizeof(b) = %zu\n", sizeof(b));  // 6
    printf("sizeof(c) = %zu\n", sizeof(c));  // 8 (na 64-bitnim sistemima)

    printf("\n--- dozvoljene operacije ---\n");
    a[0] = 'D';  // dozvoljeno – menjamo element niza
    b[0] = 'S';  // dozvoljeno – menjamo element niza

    // c[0] = 'P';  // ZABRANJENO! segmentation fault ako se odkomentariše

    strcpy(a, "Cao svete!");  // može – ima dovoljno prostora u a
    // strcpy(b, "Cao svete!"); // ne sme – b ima samo 6 bajtova!

    c = "mika";  // može – menjamo pokazivač, ne sadržaj ("pera" i dalje postoji u read-only memoriji)

    printf("\n--- posle izmena ---\n");
    printf("a = %s\n", a);
    printf("b = %s\n", b);
    printf("c = %s\n", c);

    return 0;
}
