#include <stdio.h>
#include <limits.h>
#include <stdint.h>

int main(void) {
    printf("=== Standardni tipovi ===\n");
    printf("short:        %2zu bajta  [%d, %d]\n", sizeof(short), SHRT_MIN, SHRT_MAX);
    printf("long:         %2zu bajta  [%ld, %ld]\n", sizeof(long), LONG_MIN, LONG_MAX);
    printf("long long:    %2zu bajta  [%lld, %lld]\n", sizeof(long long), LLONG_MIN, LLONG_MAX);

    printf("\n=== Unsigned varijante ===\n");
    printf("unsigned short:     %2zu bajta  [0, %u]\n", sizeof(unsigned short), USHRT_MAX);
    printf("unsigned int:       %2zu bajta  [0, %u]\n", sizeof(unsigned int), UINT_MAX);
    printf("unsigned long:      %2zu bajta  [0, %lu]\n", sizeof(unsigned long), ULONG_MAX);
    printf("unsigned long long: %2zu bajta  [0, %llu]\n", sizeof(unsigned long long), ULLONG_MAX);

    printf("\n=== Efekat preliva (overflow) ===\n");
    unsigned int u = UINT_MAX;
    int s = INT_MAX;
    printf("unsigned int overflow: %u + 1 = %u\n", u, u + 1);
    printf("signed int overflow (UB!): %d + 1 = %d (nepredvidivo)\n", s, s + 1);


    return 0;
}
