// Kopiranje datoteke (imena fajlova iz argumenata)

#include <stdio.h>

int main(int argc, char *argv[]) {
    if (argc != 3) {
        fprintf(stderr, "Upotreba: %s ulaz izlaz\n", argv[0]);
        return 1;
    }

    FILE *in = fopen(argv[1], "r");
    FILE *out = fopen(argv[2], "w");
    if (!in || !out) return 1;

    int c;
    while ((c = getc(in)) != EOF)
        putc(c, out);

    fclose(in);
    fclose(out);
    return 0;
}

/* ./kopiraj input.txt output.txt */
