#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

typedef struct {
    int   *data;      // pokazivač na elemente
    size_t size;      // trenutno zauzet broj elemenata
    size_t capacity;  // trenutno alociran broj elemenata
} IntVector;

/* Inicijalizacija praznog vektora */
void iv_init(IntVector *v) {
    v->data = NULL;
    v->size = 0;
    v->capacity = 0;
}

/* Oslobađanje memorije */
void iv_destroy(IntVector *v) {
    free(v->data);
    v->data = NULL;
    v->size = 0;
    v->capacity = 0;
}

/* Obavezna “rezerva” kapaciteta bar new_cap */
int iv_reserve(IntVector *v, size_t new_cap) {
    if (new_cap <= v->capacity) return 0;

    int *tmp = realloc(v->data, new_cap * sizeof(int));
    if (!tmp) return -1;

    v->data = tmp;
    v->capacity = new_cap;
    return 0;
}

/* push_back – dodaj element na kraj, po potrebi proširi kapacitet */
int iv_push_back(IntVector *v, int value) {
    if (v->size == v->capacity) {
        size_t new_cap = (v->capacity == 0) ? 4 : v->capacity * 2;
        if (iv_reserve(v, new_cap) != 0)
            return -1;
    }
    v->data[v->size++] = value;
    return 0;
}

/* pop_back – uzmi poslednji element (ako postoji) */
int iv_pop_back(IntVector *v, int *out) {
    if (v->size == 0) return -1;
    v->size--;
    if (out) *out = v->data[v->size];
    return 0;
}

/* pristup elementu (bezbednije: sa assert) */
int iv_at(const IntVector *v, size_t idx) {
    assert(idx < v->size);
    return v->data[idx];
}

/* promena vrednosti elementa */
void iv_set(IntVector *v, size_t idx, int value) {
    assert(idx < v->size);
    v->data[idx] = value;
}

/* resize – menjanje size; ako se proširuje, popunjava fill vrednošću */
int iv_resize(IntVector *v, size_t new_size, int fill) {
    if (new_size > v->capacity) {
        if (iv_reserve(v, new_size) != 0)
            return -1;
    }
    if (new_size > v->size) {
        for (size_t i = v->size; i < new_size; i++)
            v->data[i] = fill;
    }
    v->size = new_size;
    return 0;
}

/* clear – isprazni vektor (ne diraj capacity) */
void iv_clear(IntVector *v) {
    v->size = 0;
}

/* Primer upotrebe */
int main(void) {
    IntVector v;
    iv_init(&v);

    for (int i = 0; i < 10; i++)
        iv_push_back(&v, i * 10);

    printf("size=%zu cap=%zu\n", v.size, v.capacity);
    for (size_t i = 0; i < v.size; i++)
        printf("%d ", iv_at(&v, i));
    printf("\n");

    int last;
    iv_pop_back(&v, &last);
    printf("poslednji = %d, novi size=%zu\n", last, v.size);

    iv_resize(&v, 15, -1);  // proširi i popuni -1
    for (size_t i = 0; i < v.size; i++)
        printf("%d ", iv_at(&v, i));
    printf("\n");

    iv_clear(&v);
    printf("posle clear: size=%zu cap=%zu\n", v.size, v.capacity);

    iv_destroy(&v);
    return 0;
}
