#include <stdio.h>

/* GLOBALNA promenljiva */
int globalni_brojac = 0;

/* Funkcija sa lokalnom i lokalnom statičkom promenljivom */
void prikaz() {
    int lokalni_brojac = 0;            // obična lokalna promenljiva – resetuje se pri svakom pozivu
    static int staticki_brojac = 0;    // lokalna static – pamti vrednost između poziva

    printf("  U funkciji prikaz():\n");
    printf("    lokalni_brojac   = %d\n", lokalni_brojac);
    printf("    staticki_brojac  = %d\n", staticki_brojac);

    lokalni_brojac++;
    staticki_brojac++;
    globalni_brojac++;
}

void prikaz2() {
    //Globalna promenljiva je ovde vidljiva
    printf("Globalni: %d\n\n", globalni_brojac);

    //Ali ove dve druge nisu, ovo je greska:
    //printf("    lokalni_brojac   = %d\n", lokalni_brojac);
    //printf("    staticki_brojac  = %d\n", staticki_brojac);
}

int main() {
    printf("Globalni pre poziva: %d\n\n", globalni_brojac);

    printf("Poziv 1:\n");
    prikaz();
    printf("Globalni: %d\n\n", globalni_brojac);

    printf("Poziv 2:\n");
    prikaz();
    printf("Globalni: %d\n\n", globalni_brojac);

    printf("Poziv 3:\n");
    prikaz();
    printf("Globalni: %d\n\n", globalni_brojac);

    return 0;
}
