#include <stdio.h>

void print_bits(int x) 
{
  int i = 0;
  unsigned mask = 1 << (sizeof(x) * 8 - 1);
  while (mask) {
    if (!(i % 8)) putchar(' ');
    putchar(x & mask ? '1' : '0');
    mask >>= 1; 

    i++;
  }
}

int main() {
    unsigned int a = 0x0F0F00FF;
    unsigned int b = 0x00FF00FF;

    printf("a     = "); print_bits(a);
    putchar('\n');
    printf("b     = "); print_bits(b);
    putchar('\n');

    printf("a & b = "); print_bits(a & b);
    putchar('\n');
    printf("a | b = "); print_bits(a | b);
    putchar('\n');
    printf("a ^ b = "); print_bits(a ^ b);
    putchar('\n');
    printf("~a    = "); print_bits(~a);
    putchar('\n');

    /* Primer maske: izdvajanje donjeg bajta */
    unsigned int x = 0x12345678;
    unsigned int low = x & 0x000000FF;

    printf("\nx              = "); print_bits(x);
    putchar('\n');
    printf("x & 0x000000FF = "); print_bits(low);
    putchar('\n');

    return 0;
}
