/* frac.c */
#include <stdio.h>
#include "frac.h"

/* Pomoćna funkcija: NZD (Euklidov algoritam) */
static int gcd(int a, int b) {
    if (a < 0) a = -a;
    if (b < 0) b = -b;
    while (b != 0) {
        int t = b;
        b = a % b;
        a = t;
    }
    return (a == 0) ? 1 : a;
}

Fraction make_fraction(int num, int den) {
    Fraction f;
    if (den < 0) {
        den = -den;
        num = -num;
    }
    f.num = num;
    f.den = den;
    return simplify(f);
}

Fraction simplify(Fraction f) {
    int g = gcd(f.num, f.den);
    f.num /= g;
    f.den /= g;
    return f;
}

Fraction add(Fraction a, Fraction b) {
    Fraction result;
    result.num = a.num * b.den + b.num * a.den;
    result.den = a.den * b.den;
    return simplify(result);
}

void print_fraction(Fraction f) {
    printf("%d/%d", f.num, f.den);
}
