#include <iostream>
#include <vector>
#include <string>
#include <typeinfo>
#include <initializer_list>
#include <utility>

using namespace std;

//----------------------------------------------------------
// 1) auto + const: skida top-level const, čuva ga preko &
//----------------------------------------------------------
void demo_auto_const() {
    const int x = 42;

    auto a = x;        // a: int  (top-level const je "spao")
    const auto b = x;  // b: const int
    auto& c = x;       // c: const int&  (jer je inic. const-om)

    cout << "[demo_auto_const]\n";
    cout << "a (kopija) = " << a << "\n";
    cout << "b (const)  = " << b << "\n";
    cout << "c (ref)    = " << c << "\n\n";
}

//----------------------------------------------------------
// 2) auto i funkcija koja vraća referencu
//    - auto = kopija
//    - auto& = referenca
//----------------------------------------------------------
int global = 10;

int& get_ref() { return global; }

void demo_auto_ref_return() {
    auto  a = get_ref(); // a: int  (kopija)
    auto& b = get_ref(); // b: int& (referenca)

    a = 20;   // menja kopiju
    b = 30;   // menja global

    cout << "[demo_auto_ref_return]\n";
    cout << "global = " << global << " (očekuje se 30)\n\n";
}

//----------------------------------------------------------
// 3) auto u range-for: kopija vs referenca
//----------------------------------------------------------
void demo_range_for() {
    vector<string> v = {"MATF", "PMF", "ETF"};

    for (auto s : v) {    // KOPIJA: ne menja v
        s += "!!!";
    }

    cout << "[demo_range_for] posle for(auto s : v)\n";
    for (const auto& s : v) cout << s << " ";
    cout << "\n";

    for (auto& s : v) {   // REFERENCA: menja original
        s += "!!!";
    }

    cout << "[demo_range_for] posle for(auto& s : v)\n";
    for (const auto& s : v) cout << s << " ";
    cout << "\n\n";
}

//----------------------------------------------------------
// 4) Više deklaracija u jednom redu sa auto (loša ideja)
//    - primer za "ne radi" -> #if 0
//----------------------------------------------------------
void demo_multi_decl() {
    cout << "[demo_multi_decl]\n";
    auto x = 1;   // ok
    auto y = 2.5; // ok

#if 0
    // Poenta: auto x = 1, y = 2.5; ne radi jer bi y imao drugi tip.
    auto x2 = 1, y2 = 2.5;  // GREŠKA - različiti tipovi
#endif

    cout << "Jedna promenljiva po liniji deklaracije kada koristis auto.\n\n";
}

//----------------------------------------------------------
// 5) auto + {}: initializer_list zamka
//----------------------------------------------------------
void demo_initializer_list() {
    cout << "[demo_initializer_list]\n";

    auto a = {1, 2, 3};  // std::initializer_list<int>

    cout << "auto a = {1,2,3}; -> initializer_list<int>\n";
    cout << "Veličina a: " << a.size() << "\n";

    // razlika između auto x{1} i auto x = {1}
    auto x1 = {1};   // initializer_list<int>
    auto x2{1};      // int (C++14/17)

    cout << "typeid(x1).name(): " << typeid(x1).name() << "\n";
    cout << "typeid(x2).name(): " << typeid(x2).name() << "\n\n";

#if 0
    // Poenta: mešanje tipova unutar {} sa auto često daje grešku.
    auto bad = {1, 2.0};  // GREŠKA: ne može initializer_list sa mešanim tipovima
#endif
}

//----------------------------------------------------------
// 6) auto i ?: (mešanje tipova, zajednički tip)
//----------------------------------------------------------
void demo_auto_conditional() {
    cout << "[demo_auto_conditional]\n";

    auto x = (true ? 2 : 3.5);  // int i double -> common type = double
    cout << "auto x = (true ? 2 : 3.5); -> tip je verovatno double\n";
    cout << "x = " << x << "\n\n";
}

//----------------------------------------------------------
// 7) auto kao povratna vrednost: mešanje tipova u granama
//----------------------------------------------------------
auto f_mixed(bool flag) {
    if (flag)
        return 1;    // int
#if 0        
    else
        return 3.14; // double
        // -> ne ume da ne zna ovo da resi
#endif        
}

void demo_auto_return_mixed() {
    cout << "[demo_auto_return_mixed]\n";

    auto a = f_mixed(true);
    auto b = f_mixed(false);

    cout << "f_mixed(true)  = " << a << "\n";
    cout << "f_mixed(false) = " << b << "\n";
    cout << "typeid(a).name(): " << typeid(a).name() << " (ocekujemo double)\n\n";
}

//----------------------------------------------------------
// 10) Gde nije pametno koristiti auto (primeri kao komentar)
//----------------------------------------------------------
void demo_where_not_to_use_auto() {
    cout << "[demo_where_not_to_use_auto]\n";
    cout << "Ovde samo ideja, nema konkretnih primera u kodu.\n";
    cout << "- javni interfejsi biblioteka (bolje eksplicitni tipovi)\n";
    cout << "- kada je bitno da se vidi tacno koji je tip (npr. int vs long long)\n\n";

#if 0
    // C++20 only - nije za produkciju bez jasne namere.
    auto dupliraj(auto x) { return 2 * x; }
#endif
}

//----------------------------------------------------------
// main: pozivaš šta hoćeš na času
//----------------------------------------------------------
int main() {
    demo_auto_const();
    demo_auto_ref_return();
    demo_range_for();
    demo_multi_decl();
    demo_initializer_list();
    demo_auto_conditional();
    demo_auto_return_mixed();
    demo_where_not_to_use_auto();

    return 0;
}
