#include <iostream>
#include <vector>
#include <initializer_list>
#include <string>
#include <typeinfo>

using namespace std;

//-------------------------------------------------------------
// 1) Funkcija koja prima initializer_list
//-------------------------------------------------------------
void f(initializer_list<int> xs) {
    cout << "f() dobila " << xs.size() << " elemenata: ";
    for (int x : xs) cout << x << " ";
    cout << "\n";
}

void demo_simple_list() {
    cout << "\n[demo_simple_list]\n";
    f({1, 2, 3});
    f({10});        // OK – jedan element
    f({});          // OK – prazan
}

//-------------------------------------------------------------
// 2) Klasa sa ctor(initializer_list<T>) – preferira se nad drugim ctor-ima
//-------------------------------------------------------------
struct Skup {
    vector<int> v;

    Skup() { cout << "Skup(): prazno\n"; }

    Skup(int x) {
        cout << "Skup(int) ctor\n";
        v.push_back(x);
    }

    Skup(initializer_list<int> xs) {
        cout << "Skup(initializer_list) ctor\n";
        v.assign(xs);
    }
};

void demo_ctor_preference() {
    cout << "\n[demo_ctor_preference]\n";

    Skup a{5};      // bira initializer_list → NE Skup(int)!
    Skup b(5);      // bira Skup(int)
    Skup c{1,2,3};  // initializer_list
}

//-------------------------------------------------------------
// 3) initializer_list = copy-on-write view (ne pravi duboku kopiju)
//    → elementi su const int*
//-------------------------------------------------------------
void demo_const_elements() {
    cout << "\n[demo_const_elements]\n";

    initializer_list<int> xs = {1,2,3};

    cout << "Tip elemenata: " << typeid(*xs.begin()).name() << "\n";

#if 0
    // xs.begin()[0] = 5;        // ❌ ne može: elementi su konstante
#endif

    cout << "Elementi su const — ne možete ih menjati.\n";
}

//-------------------------------------------------------------
// 4) initializer_list i {} vs {{}}
//    – “matrica” inicijalizacija
//-------------------------------------------------------------
struct Mat {
    vector<vector<int>> m;

    Mat(initializer_list<initializer_list<int>> rows) {
        cout << "Mat(initializer_list<initializer_list<int>>)\n";
        for (auto& r : rows) m.emplace_back(r);  // svaki r je ilist<int>
    }
};

void demo_matrix() {
    cout << "\n[demo_matrix]\n";

    Mat M = {
        {1,2,3},
        {4,5},
        {6}
    };

    cout << "M ima " << M.m.size() << " redova.\n";
}




//-------------------------------------------------------------
int main() {
    demo_simple_list();
    demo_ctor_preference();
    demo_const_elements();
    demo_matrix();
}
