#include <iostream>
#include <string>
#include <vector>
using namespace std;

//-----------------------------------------------------------
// 1) Osnovni primer — brojanje instanci
//-----------------------------------------------------------
class Brojac {
public:
    static int ukupan_broj;   // deklaracija

    Brojac() {
        ++ukupan_broj;
    }
};

// definicija statičkog člana (obavezno!)
int Brojac::ukupan_broj = 0;

void demo_simple_counter() {
    cout << "\n[demo_simple_counter]\n";

    Brojac a, b, c;
    cout << "Ukupan broj objekata: " << Brojac::ukupan_broj << "\n";

    Brojac d;
    cout << "Ukupan broj objekata: " << Brojac::ukupan_broj << "\n";
}

//-----------------------------------------------------------
// 4) inline static (C++17) — nema potrebe za definicijom u .cpp
//-----------------------------------------------------------
class Parametri {
public:
    inline static const int MAX_BRZINA = 130;  // nema definicije van klase
};

void demo_inline_static() {
    cout << "\n[demo_inline_static]\n";

    cout << "MAX_BRZINA = " << Parametri::MAX_BRZINA << "\n";
}

//-----------------------------------------------------------
// 5) Statički član kao "globalni resurs" kojeg dele svi objekti
//-----------------------------------------------------------
class Logger {
public:
    static vector<string> poruke;

    void log(const string& s) {
        poruke.push_back(s);
    }
};

vector<string> Logger::poruke;  // definicija

void demo_shared_resource() {
    cout << "\n[demo_shared_resource]\n";

    Logger a, b;

    a.log("Start");
    b.log("Ucitavanje");
    a.log("Kraj");

    cout << "Sve poruke:\n";
    for (const auto& m : Logger::poruke)
        cout << " - " << m << "\n";
}

//-----------------------------------------------------------
// 6) Statički član u šablonu — svaki T ima svoj statički član
//-----------------------------------------------------------
template <typename T>
class StatZaTip {
public:
    static int vrednost;
};

template <typename T>
int StatZaTip<T>::vrednost = 0;

void demo_template_static() {
    cout << "\n[demo_template_static]\n";

    StatZaTip<int>::vrednost = 10;
    StatZaTip<double>::vrednost = 20;

    cout << "StatZaTip<int>::vrednost    = " << StatZaTip<int>::vrednost << "\n";
    cout << "StatZaTip<double>::vrednost = " << StatZaTip<double>::vrednost << "\n";
    cout << "(Različita instanca statičkog člana za svaki tip!)\n";
}

//-----------------------------------------------------------
int main() {
    demo_simple_counter();
    demo_inline_static();
    demo_shared_resource();
    demo_template_static();
}
