// sabloni_osnove.cpp
//
// Najjednostavniji primeri šablona – samo osnove.
// Fokus: kako se šablon definiše i kako se koristi.
// Ovo je namenjeno za čas, kao brzi pregled.

#include <iostream>
#include <string>
using std::cout;
using std::endl;

// ------------------------------------------------------------
// 1) Funkcijski šablon – najjednostavniji oblik generičkog koda
// ------------------------------------------------------------

template<typename T>
T maksimum(T a, T b) {
    return (a < b) ? b : a;
}

// ------------------------------------------------------------
// 2) Šablon klase – jednostavna kutija koja čuva jedan element
// ------------------------------------------------------------

template<typename T>
class Box {
private:
    T vrednost;

public:
    Box(const T& v) : vrednost(v) {}

    T get() const { return vrednost; }
    void set(const T& v) { vrednost = v; }
};

// ------------------------------------------------------------
// 3) Vrednosni parametar šablona (minimalan primer)
// ------------------------------------------------------------

template<typename T, int N>
struct FixedArray {
    T data[N];

    void fill(const T& x) {
        for (int i = 0; i < N; i++)
            data[i] = x;
    }

    void print() const {
        for (int i = 0; i < N; i++)
            cout << data[i] << " ";
        cout << endl;
    }
};

// ------------------------------------------------------------
// 4) using – najjednostavniji alias tipa
// ------------------------------------------------------------

template<typename T>
using Vec2 = Box<T>;  // „novi naziv“ za Box<T>, samo ilustracija

// ------------------------------------------------------------

int main() {
    cout << "\n=== 1) Funkcijski šablon ===\n";
    cout << "maksimum(3, 7) = " << maksimum(3, 7) << endl;
    cout << "maksimum(2.5, 1.1) = " << maksimum(2.5, 1.1) << endl;

    // dedukcija radi: T=int ili T=double

    cout << "\n=== 2) Šablon klase: Box<T> ===\n";
    Box<int> b1(42);
    Box<std::string> b2("pozdrav");

    cout << "b1 = " << b1.get() << endl;
    cout << "b2 = " << b2.get() << endl;

    cout << "\n=== 3) Vrednosni parametar šablona ===\n";
    FixedArray<int, 4> arr;
    arr.fill(7);
    arr.print();

    cout << "\n=== 4) using alias ===\n";
    Vec2<int> v(123);
    cout << "Vec2<int> v = " << v.get() << endl;


    return 0;
}
