// file_stream_osnove.cpp
//
// Najosnovniji primeri rada sa datotekama u C++.
// Fokus: ifstream, ofstream, append mod, getline,
//       prosleđivanje ostream& funkcijama,
//       i sstream za formatiranje / parsiranje.
//

#include <iostream>
#include <fstream>
#include <sstream>
#include <string>

using std::cout;
using std::cerr;
using std::endl;
using std::string;

// ------------------------------------------------------------
// 1) Pisanje u fajl
// ------------------------------------------------------------
void primer_pisanje() {
    cout << "\n=== 1) Pisanje u fajl ===\n";

    std::ofstream out("primer.txt");
    if (!out) {
        cerr << "Greška: ne mogu da otvorim fajl!\n";
        return;
    }

    out << "Prvi red\n";
    out << "Drugi red\n";
    // out.close(); // nije neophodno: destructor radi posao
}

// ------------------------------------------------------------
// 2) Append mod (dodavanje na kraj fajla)
// ------------------------------------------------------------
void primer_append() {
    cout << "\n=== 2) Append mod ===\n";

    std::ofstream out("primer.txt", std::ios::app);
    if (!out) {
        cerr << "Nije moguće otvoriti fajl.\n";
        return;
    }

    out << "Dodat red (append)\n";
}

// ------------------------------------------------------------
// 3) Čitanje iz fajla (getline)
// ------------------------------------------------------------
void primer_citanje() {
    cout << "\n=== 3) Čitanje iz fajla ===\n";

    std::ifstream in("primer.txt");
    if (!in) {
        cerr << "Nije moguće otvoriti primer.txt\n";
        return;
    }

    string red;
    while (std::getline(in, red)) {
        cout << "→ " << red << endl;
    }
}

// ------------------------------------------------------------
// 4) Prosleđivanje ostream& funkciji
// ------------------------------------------------------------
void ispis( std::ostream& out, int x ) {
    out << "Rezultat: " << x << endl;
}

void primer_prosledjivanje_streama() {
    cout << "\n=== 4) Prosleđivanje ostream& ===\n";

    ispis(cout, 123);  // ispis na ekran

    std::ofstream fajl("rez.txt");
    if (fajl)
        ispis(fajl, 456); // ispis u fajl
}

// ------------------------------------------------------------

int main() {
    primer_pisanje();
    primer_append();
    primer_citanje();
    primer_prosledjivanje_streama();
}
