// ranges_osnove.cpp
//
// Najosnovniji primeri C++20 ranges biblioteke.
// Fokus: filter, transform, take, sort — i da se vidi razlika
// između klasičnog <algorithm> i <ranges> pristupa.
//
// Kompajlirati sa:
//     g++ -std=c++20 ranges_osnove.cpp -o ranges

#include <iostream>
#include <vector>
#include <ranges>
#include <algorithm>

using std::cout;
using std::endl;

// ------------------------------------------------------------
// 1) Osnovni pipeline: filter + transform
// ------------------------------------------------------------
void primer_pipeline() {
    cout << "\n=== 1) Osnovni pipeline ===\n";

    std::vector<int> v = {1, 2, 3, 4, 5, 6};

    // Pogled (view): parni brojevi, pa kvadriranje
    auto kvadrati_parnih =
        v
        | std::views::filter([](int x){ return x % 2 == 0; })
        | std::views::transform([](int x){ return x * x; });

    for (int x : kvadrati_parnih)
        cout << x << " ";
    cout << endl;
}

// ------------------------------------------------------------
// 2) Kombinovanje više operacija: filter + take
// ------------------------------------------------------------
void primer_take() {
    cout << "\n=== 2) filter + take ===\n";

    std::vector<int> v = {3, 8, 1, 5, 2, 9, 4};

    for (int x : v
                | std::views::filter([](int x){ return x > 3; })
                | std::views::take(3))
        cout << x << " ";
    cout << endl;
}

// ------------------------------------------------------------
// 3) ranges::sort — algoritam direktno nad kolekcijom
// ------------------------------------------------------------
void primer_sort() {
    cout << "\n=== 3) ranges::sort ===\n";

    std::vector<int> v = {7, 2, 9, 4, 1, 5};

    std::ranges::sort(v);  // nema begin/end

    for (int x : v)
        cout << x << " ";
    cout << endl;
}

// ------------------------------------------------------------

int main() {
    primer_pipeline();
    primer_take();
    primer_sort();
}
