#include <stdio.h>
#include <string.h>
#include <stdbool.h>

void lose_resenje(FILE* f) {
    char buf[2000];

    while (fgets(buf, sizeof(buf), f)) {
        long sum = 0;

        // LOŠE: strlen() se poziva u SVAKOJ iteraciji
        for (long i = 0; i < strlen(buf); i++) {
            sum += buf[i];   // nešto da "radimo"
        }
    }
}

void dobro_resenje(FILE* f) {
    char buf[2000];

    while (fgets(buf, sizeof(buf), f)) {
        long sum = 0;

        for (size_t i = 0; buf[i]; i++) {
            sum += buf[i];
        }
    }
}

int main(int argc, char **argv) {
    if (argc != 2) {
        fprintf(stderr, "Pozovi sa: %s [dobro|lose]\n", argv[0]);
        return 1;
    }

    FILE* f = fopen("ulaz.txt", "r");
    if (!f) return 1;

    if (strcmp(argv[1], "dobro") == 0) {
        dobro_resenje(f);
    } else if (strcmp(argv[1], "lose") == 0) {
        lose_resenje(f);
    } else {
        fprintf(stderr, "Unknown option: %s\n", argv[1]);
        return 1;
    }

    return 0;
}
