#include <stdio.h>
#include <stdlib.h>
#include <string.h>

volatile long global_sum = 0;

// -----------------------------------------------------------
// LOŠE REŠENJE — raste po +10 elemenata pri svakoj popuni
// -----------------------------------------------------------
void lose_resenje() {
    int capacity = 10;
    int size = 0;
    int *a = malloc(capacity * sizeof(int));

    int x;
    while (scanf("%d", &x) == 1) {
        if (size == capacity) {
            capacity += 10;   // mali korak — veoma loše
            a = realloc(a, capacity * sizeof(int));
        }
        a[size++] = x;
    }

    long sum = 0;
    for (int i = 0; i < size; i++)
        sum += a[i];

    global_sum += sum;
    free(a);
}

// -----------------------------------------------------------
// DOBRO REŠENJE — kapacitet se duplira (amortizovano O(1))
// -----------------------------------------------------------
void dobro_resenje() {
    int capacity = 10;
    int size = 0;
    int *a = malloc(capacity * sizeof(int));

    int x;
    while (scanf("%d", &x) == 1) {
        if (size == capacity) {
            capacity *= 2;    // eksponencijalni rast — veoma efikasno
            a = realloc(a, capacity * sizeof(int));
        }
        a[size++] = x;
    }

    long sum = 0;
    for (int i = 0; i < size; i++)
        sum += a[i];

    global_sum += sum;
    free(a);
}

// -----------------------------------------------------------
int main(int argc, char **argv) {
    if (argc != 2) {
        fprintf(stderr, "Pozovi sa: %s [dobro|lose]\n", argv[0]);
        return 1;
    }

    if (strcmp(argv[1], "lose") == 0) {
        lose_resenje();
    } else if (strcmp(argv[1], "dobro") == 0) {
        dobro_resenje();
    } else {
        fprintf(stderr, "Unknown option\n");
        return 1;
    }

    // prisili kompajler da ne izbaci sve
    if (global_sum == 42) printf("magic\n");

    return 0;
}
