#include <iostream>
#include "lista.hpp"

int main()
{
    using dl::lista;

    lista<int> l;

    // ------------------------------
    // Dodavanje elemenata
    // ------------------------------
    l.push_back(10);
    l.push_back(20);
    l.push_front(5);   // lista: 5 10 20

    std::cout << "Pocetna lista: ";
    for (auto it = l.begin(); it != l.end(); ++it)
        std::cout << *it << " ";
    std::cout << "\n";

    // ------------------------------
    // Umetanje elementa
    // ------------------------------
    auto it = l.begin();
    ++it;  // pozicija iza prvog elementa (iza 5)

    l.insert(it, 7);   // lista: 5 7 10 20

    std::cout << "Nakon umetanja 7: ";
    for (auto x : l)   // radi jer smo implementirali iterator
        std::cout << x << " ";
    std::cout << "\n";

    // ------------------------------
    // Brisanje elementa
    // ------------------------------
    auto it2 = l.begin();
    ++it2; // pokazuje na 7

    l.erase(it2);   // brise 7 -> lista: 5 10 20

    std::cout << "Nakon brisanja 7: ";
    for (auto x : l)
        std::cout << x << " ";
    std::cout << "\n";

    // ------------------------------
    // Demonstracija kretanja unazad (--it)
    // ------------------------------
    auto kraj = l.end();
    --kraj;  // sada "gleda" poslednji element (20)

    std::cout << "Kretanje unazad: ";
    std::cout << *kraj;  // 20

    --kraj;
    std::cout << " " << *kraj;  // 10

    --kraj;
    std::cout << " " << *kraj;  // 5
    std::cout << "\n";

    return 0;
}
