#include <stdio.h>
#include <stdlib.h>
#include "lista.h"

/* Ispis u oba smera — samo za demonstraciju rada dvostruke liste */
void ispisi_unazad(cvor *sentinel)
{
    printf("Unazad: ");
    for (cvor *p = sentinel->prethodni; p != sentinel; p = p->prethodni)
        printf("%c", p->c);
    printf("\n");
}

int main(void)
{
    /* 1. Kreiranje liste */
    cvor *lista = inicijalizuj_listu();
    if (lista == NULL) {
        fprintf(stderr, "Neuspešna alokacija sentinela.\n");
        return 1;
    }

    printf("Lista kreirana. Da li je prazna? %s\n",
           prazna(lista) ? "DA" : "NE");

    /* 2. Dodavanje elemenata na početak */
    ubaci_na_pocetak(lista, 'C');
    ubaci_na_pocetak(lista, 'B');
    ubaci_na_pocetak(lista, 'A');

    printf("Nakon ubacivanja na početak (A,B,C): ");
    ispisi_listu(lista);
    ispisi_unazad(lista);

    /* 3. Dodavanje elemenata na kraj */
    ubaci_na_kraj(lista, 'D');
    ubaci_na_kraj(lista, 'E');

    printf("Nakon ubacivanja na kraj (D,E): ");
    ispisi_listu(lista);
    ispisi_unazad(lista);

    /* 4. Ubacivanje ispred i iza proizvoljnog čvora */
    cvor *drugi = lista->sledeci->sledeci;  /* čvor sa 'B' */
    ubaci_prethodni(drugi, '+');            /* pre 'B' */
    ubaci_sledeci(drugi, '-');              /* iza 'B' */

    printf("Nakon umetanja pre i posle čvora 'B': ");
    ispisi_listu(lista);

    /* 5. Brisanje određenog čvora (npr. čvora sa '+') */
    printf("Brišem čvor '+'.\n");
    cvor *p = lista->sledeci;
    while (p != lista && p->c != '+') 
        p = p->sledeci;

    if (p != lista)      /* čvor pronađen */
        obrisi_cvor(p);

    printf("Lista nakon brisanja '+': ");
    ispisi_listu(lista);

    /* 6. Brisanje cele liste (osim sentinela) */
    obrisi_listu(lista);

    printf("Nakon brisanja cele liste: ");
    ispisi_listu(lista);
    printf("Da li je sada prazna? %s\n",
           prazna(lista) ? "DA" : "NE");

    /* 7. Oslobađanje sentinela */
    free(lista);

    return 0;
}
