/* kruzna.c */

#include <stdlib.h>
#include <assert.h>
#include "kruzna.h"

cvor *napravi_cvor(int x, cvor *sledeci)
{
    cvor *novi = malloc(sizeof(cvor));
    if (novi == NULL)
        return NULL;

    novi->x       = x;
    novi->sledeci = sledeci;
    return novi;
}

cvor *dodaj_na_kraj(cvor *kraj, int x)
{
    assert(kraj != NULL);

    kraj->sledeci = napravi_cvor(x, NULL);
    return kraj->sledeci;
}

cvor *obrisi_tekuci(cvor *tekuci)
{
    assert(tekuci != NULL);
    assert(tekuci->sledeci != NULL);

    cvor *tmp       = tekuci->sledeci;
    tekuci->x       = tmp->x;
    tekuci->sledeci = tmp->sledeci;
    free(tmp);

    return tekuci;
}

int preostali_plesac(int n, int m)
{
    cvor *pocetak, *kraj, *tekuci;
    int i, k;

    /* formiramo listu sa elementima 1, 2, ..., n */
    pocetak = napravi_cvor(1, NULL);
    if (pocetak == NULL)
        return -1;

    kraj = pocetak;

    for (i = 2; i <= n; i++) {
        kraj = dodaj_na_kraj(kraj, i);
        if (kraj == NULL)
            return -1;
    }

    /* spajamo kraj i početak – dobijamo kružnu listu */
    kraj->sledeci = pocetak;

    tekuci = pocetak;

    /* dok ne preostane jedan plesač */
    for (k = n; k > 1; k--) {
        /* pomeramo se na m-ti čvor od tekućeg */
        for (i = 0; i < m - 1; i++)
            tekuci = tekuci->sledeci;

        /* brišemo tekući čvor i nastavljamo sa sledećeg */
        tekuci = obrisi_tekuci(tekuci);
    }

    /* preostali čvor čuva rezultat */
    i = tekuci->x;
    free(tekuci);

    return i;
}
