#include <stdlib.h>
#include "ciklus.h"

cvor *napravi_cvor(int x)
{
    cvor *novi = malloc(sizeof(cvor));
    if (novi == NULL)
        return NULL;

    novi->x       = x;
    novi->sledeci = NULL;
    return novi;
}

void dodaj_na_kraj(cvor **glava, int x)
{
    cvor *novi = napravi_cvor(x);
    if (novi == NULL)
        return;

    if (*glava == NULL) {
        *glava = novi;
        return;
    }

    cvor *p = *glava;
    while (p->sledeci != NULL)
        p = p->sledeci;

    p->sledeci = novi;
}

void oslobodi_listu(cvor *glava)
{
    while (glava != NULL) {
        cvor *sledeci = glava->sledeci;
        free(glava);
        glava = sledeci;
    }
}

/* Prva faza: proveravamo da li postoji susret "sporog" i "brzog" pokazivača. */
int ima_ciklus(cvor *glava)
{
    cvor *spori = glava;
    cvor *brzi  = glava;

    while (brzi != NULL && brzi->sledeci != NULL) {
        spori = spori->sledeci;               /* pomeraj 1 */
        brzi  = brzi->sledeci->sledeci;       /* pomeraj 2 */

        if (spori == brzi)
            return 1; /* postoji ciklus */
    }
    return 0; /* nema ciklusa */
}

/* Druga faza: vraćamo pokazivače na početak ciklusa. */
cvor *pocetak_ciklusa(cvor *glava)
{
    cvor *spori = glava;
    cvor *brzi  = glava;

    /* 1) Pronalazimo tačku susreta unutar ciklusa (ako postoji). */
    int nadjen = 0;
    while (brzi != NULL && brzi->sledeci != NULL) {
        spori = spori->sledeci;
        brzi  = brzi->sledeci->sledeci;

        if (spori == brzi) {
            nadjen = 1;
            break;
        }
    }

    if (!nadjen)
        return NULL; /* nema ciklusa */

    /* 2) Jedan pokazivač vraćamo na početak liste. */
    spori = glava;

    /* 3) Pomeramo oba pokazivača po jedan korak; susret je početak ciklusa. */
    while (spori != brzi) {
        spori = spori->sledeci;
        brzi  = brzi->sledeci;
    }

    return spori;
}
