#ifndef CIKLUS_H
#define CIKLUS_H

typedef struct cvor {
    int x;
    struct cvor *sledeci;
} cvor;

/* Pomoćne funkcije za rad sa listom (bez ciklusa u opštem slučaju). */

/* Kreira novi čvor sa datom vrednošću i sledećim pokazivačem NULL. */
cvor *napravi_cvor(int x);

/* Dodaje novi čvor na kraj liste. */
void dodaj_na_kraj(cvor **glava, int x);

/* Oslobađa linearnu listu (bez ciklusa). */
void oslobodi_listu(cvor *glava);

/* Funkcije za rad sa ciklusom. */

/* Proverava da li lista sadrži ciklus. */
int ima_ciklus(cvor *glava);

/* Vraća pokazivač na početak ciklusa, ili NULL ako ciklus ne postoji. */
cvor *pocetak_ciklusa(cvor *glava);

#endif /* CIKLUS_H */
