#include <stdio.h>
#include "ciklus.h"

int main(void)
{
    cvor *lista = NULL;

    /* Formiramo listu: 1 -> 2 -> 3 -> 4 -> 5 -> NULL */
    for (int i = 1; i <= 5; i++)
        dodaj_na_kraj(&lista, i);

    /* Pronalazimo pokazivač na čvor sa vrednošću 3. */
    cvor *p = lista;
    cvor *cvor_sa_3 = NULL;
    while (p != NULL) {
        if (p->x == 3) {
            cvor_sa_3 = p;
            break;
        }
        p = p->sledeci;
    }

    /* Pronalazimo poslednji čvor i "pravimo" ciklus: 5 -> 3. */
    cvor *poslednji = lista;
    while (poslednji->sledeci != NULL)
        poslednji = poslednji->sledeci;

    poslednji->sledeci = cvor_sa_3;  /* sada postoji ciklus */

    /* Proveravamo da li postoji ciklus i gde počinje. */
    if (ima_ciklus(lista)) {
        cvor *pocetak = pocetak_ciklusa(lista);
        if (pocetak != NULL)
            printf("Pocetak ciklusa je cvor sa vrednoscu %d.\n", pocetak->x);
        else
            printf("Postoji ciklus, ali pocetak nije pronadjen (neocekivano).\n");
    } else {
        printf("Lista nema ciklus.\n");
    }

    /* Napomena: lista sada ima ciklus, pa ovde ne pozivamo oslobodi_listu.
       U realnom programu trebalo bi prvo "razbiti" ciklus, pa je tek onda osloboditi. */

    return 0;
}
